-- Send Provisional Offer Letter

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_PROVISIONAL_OFFER_LETTER_DL');

update sql_dtprovider set sqlQuery="SELECT
        T1.id AS USER_ID,
        T1.progBatchSeatConfigId as DLS_PROGRAM_BATCH_SEAT_CONFIG_ID 
 	FROM
    	`application_program` T1 
    	INNER JOIN
       	`application` T2  ON T1.applicationId = T2.id 
    	INNER JOIN
        `prog_batch_seat_config` T3 ON T3.id = T1.`progBatchSeatConfigId` 
 	WHERE
        T1.id IN (namedParams)
 	<MSG@PROGRAM_CRITERIA> AND T1.programId IN (msg_scope_programIds)</MSG>
 	<MSG@BATCH_CRITERIA> AND T3.programBatchId IN (msg_scope_batchIds)</MSG>" 
        where dataProviderId=@dataProviderId;

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');

 update sql_dtprovider set sqlQuery="SELECT
     T6.id AS ID,
     T3.`salutationName` AS SALUTATION_NAME,
     T2.`firstName` AS FIRST_NAME,
     T2.`middleName` AS MIDDLE_NAME,
     T2.`lastName` AS LAST_NAME,
     T2.`emailId` AS EMAIL_ID,
     T2.`mobileNumber` AS MOBILE_NO,
     T2.`mobileCountryCode` AS MOBILE_CODE,
     T5.`loginId` AS LOGIN_ID,
     CONVERT(FROM_BASE64(T5.passwordBase64) USING utf8) AS PASSWORD,
     CONCAT(T9.addressText,' ',T10.cityName,', ',T11.countryName,', ',T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
     DATE_FORMAT(T14.admissionOfferStartDate ,'%d-%m-%Y') as OFFER_LETTER_START_DATE,
     DATE_FORMAT(T14.admissionOfferEndDate ,'%d-%m-%Y') as OFFER_LETTER_END_DATE,
     CONCAT(T9.phoneCountryCode,'-',T9.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
      T9.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
      T9.websiteURL AS ACADEMY_LOCATION_URL,
     'APPLICANT' AS USER_TYPE_KEY,
     (Case 
          when 
              T15.offerType = 'FIRM'
          then 
              'Firm'
    when 
              T15.offerType = 'PROVISIONAL'
          then 
              'Provisional'
          else '' 
      end) as FIRM_OR_PROVISIONAL,
      (CASE
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'APPLIED'
          THEN
              'Applied'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'NOT_APPLIED'
          THEN
              'Not Applied'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'SOLD'
          THEN
              'Sold'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'SUBMITTED'
          THEN
              'Submitted'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'APPROVED'
          THEN
              'Approved'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'REJECTED'
          THEN
              'Rejected'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'WITHDRAWN'
          THEN
              'Withdrawn'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'CLOSED'
          THEN
              'Closed'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'DIRECT_ADMISSION'
          THEN
              'Direct Admission'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'MID_TERM_ADMISSION'
          THEN
              'Mid term admission'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
          THEN
              'Direct submission token generated'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
          THEN
              'Form sale token generated'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'NOT_SUBMITTED'
          THEN
              'Not Submitted'
          WHEN
              T1.currentStatus IS NOT NULL
                  AND T1.currentStatus = 'ADMISSION_GRANTED'
          THEN
              'Admission granted'
          ELSE ''
      END) AS APPLICATION_STATUS,
      (CASE
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'OFFER_LETTER_ACCEPTED'
          THEN
              'Offer letter accepted'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'OFFER_LETTER_ISSUED'
          THEN
              'Offer letter issued'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'OFFER_LETTER_REJECTED'
          THEN
              'Offer letter rejected'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'OFFER_LETTER_DUE'
          THEN
              'Offer letter due'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'ACTIVE'
          THEN
              'Active'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'APPROVED'
          THEN
              'Approved'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'ADMITTED'
          THEN
              'Admitted'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'ADMITTED_ON_TRIAL'
          THEN
              'Admitted on trial'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'ADMITTED_ON_PROVISIONAL'
          THEN
              'Admitted on provisional'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'REJECTED'
          THEN
              'Rejected'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'WITHDRAWN'
          THEN
              'Withdrawn'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
          THEN
              'Withdrawn after accepting offer letter'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'CLOSED'
          THEN
              'Closed'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
          THEN
              'Provisional offer issued'
              WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
          THEN
              'Provisional offer rejected'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'PROVISIONAL_OFFER_DUE'
          THEN
              'Provisional offer due'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'OFFER_EXPIRED'
          THEN
              'Offer Expired'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
          THEN
              'Provisional Offer Expired'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'ESCALATED'
          THEN
              'Escalated'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'ESCALATED_OFFER_REVIEWED'
          THEN
              'Escalated Offer Reviewed'
          WHEN
              T6.currentStatus IS NOT NULL
                  AND T6.currentStatus = 'WAITING_LIST'
          THEN
              'Waiting List'  
          ELSE ''
      END) AS OFFER_STATUS,
      DATE_FORMAT(T1.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
      (CASE
          WHEN
              T7.logoUrl IS NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl,
                      '/',
                      'emailer/images/logo_default_image.png')
          WHEN
              T7.logoUrl IS NULL
                  AND org.orgUrl IS NULL
          THEN
              'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
          ELSE CONCAT(org.orgUrl, '/', T7.logoUrl)
      END) AS LOGO_URL,
      (CASE
          WHEN
              T7.headerUrl IS NOT NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl, '/', T7.headerUrl)
          ELSE NULL
      END) AS HEADER_URL,
      (Case 
          when 
              T7.footerUrl is not null 
                  and org.orgUrl IS NOT NULL 
          then 
              CONCAT(org.orgUrl, '/', T7.footerUrl)
          else NULL 
      end) as FOOTER_URL,
      T7.id as ACADEMY_LOCATION_ID,
      T7.academyId as ACADEMY_ID,
      ml.code as LANGUAGE_KEY,
      ml.itemValue as CORRESPONDENCE_LANGUAGE,
       T16.itemValue as CURRENT_ACTIVITY,
       T19.groupName AS PROGRAM_GROUP_NAME
  FROM
     `application` T1 
  		INNER JOIN
  	`applicant_person` T2 ON T2.id = T1.applicantPersonId 
 		LEFT JOIN 
      `current_activity` T16 ON T16.id = T2.current_activity_id
  		LEFT JOIN
  	`salutations` T3 ON T3.`id` = T2.`salutationId`
  		LEFT JOIN
  	`external_user_association` T4 ON T4.`applicationId` = T1.`id`
  		LEFT JOIN
  	`external_users` T5 ON T5.`id` = T4.`externalUserId`
      INNER JOIN
      `application_program` T6 ON T6.applicationId = T1.id
          LEFT JOIN
      `prog_batch_seat_config` T17 
       ON T17.id = T6.`progBatchSeatConfigId`
         INNER JOIN
        `programs` T18 ON T18.id = T6.programId   
          INNER JOIN
         `program_group` T19 ON T19.id = T1.programGroupId
  		LEFT OUTER JOIN
      `academy_location` T7 ON T7.id = T6.academyLocationId
  		LEFT OUTER JOIN
      `academy_location_addresses` T8 ON T8.academyLocationId = T7.id
  		LEFT OUTER JOIN
      `address` T9 ON T9.id = T8.addressId && T9.addressTypeId=10
  		LEFT OUTER JOIN
  	`city` T10 ON T10.id = T9.cityId
  		LEFT OUTER JOIN
  	`country` T11 ON T11.id = T10.countryId
  		LEFT OUTER JOIN
  	`country_region` T12 ON T12.id = T10.countryRegionId
  		LEFT JOIN
  	`program_selection_process` T13 on T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
  		LEFT JOIN
  	`prog_slctn_process_admisn_conf` T14 on T14.programSelectionProcessId = T13.id
      LEFT JOIN
 	`app_program_adm_details` T15	 on T15.applicationProgramId = T6.id and T15.isLatest = true
     LEFT OUTER JOIN
 	`organizations` org ON org.id = (SELECT 
              MAX(id)
          FROM
              organizations)
      LEFT JOIN
         multi_language ml on ml.id=T2.correspondence_language
  WHERE
     T6.id IN 
     (
   namedParams
     ) group by T2.id" ,
	jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "mobile Code",
              "resultKey": "MOBILE_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "Login Id",
              "resultKey": "LOGIN_ID",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "Password",
              "resultKey": "PASSWORD",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "Academy Location Address",
              "resultKey": "ACADEMY_LOCATION_ADDRESS",
              "displayCode": "",
              "displayOrder": 10
          },
          {
              "id": 12,
              "value": "Offer Letter Start Date",
              "resultKey": "OFFER_LETTER_START_DATE",
              "displayCode": "",
              "displayOrder": 11
          },
          {
              "id": 13,
              "value": "Offer Letter End Date",
              "resultKey": "OFFER_LETTER_END_DATE",
              "displayCode": "",
              "displayOrder": 12
          },
          {
              "id": 14,
              "value": "applicationStatus",
              "resultKey": "APPLICATION_STATUS",
              "displayCode": "",
              "displayOrder": 13
          },
          {
              "id": 15,
              "value": "offerStatus",
              "resultKey": "OFFER_STATUS",
              "displayCode": "",
              "displayOrder": 14
          },
          {
              "id": 16,
              "value": "firmOrProvisional",
              "resultKey": "FIRM_OR_PROVISIONAL",
              "displayCode": "",
              "displayOrder": 15
          },
          {
              "id": 17,
              "value": "applicationDate",
              "resultKey": "APPLICATION_DATE",
              "displayCode": "",
              "displayOrder": 16
          },
          {
              "id": 18,
              "value": "logoURL",
              "resultKey": "LOGO_URL",
              "displayCode": "",
              "displayOrder": 17
          },
          {
              "id": 19,
              "value": "headerUrl",
              "resultKey": "HEADER_URL",
              "displayCode": "",
              "displayOrder": 18
          },
          {
              "id": 20,
              "value": "footerUrl",
              "resultKey": "FOOTER_URL",
              "displayCode": "",
              "displayOrder": 19
          },
          {
              "id": 21,
              "value": "academyLocationEmailId",
              "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 20
          },
          {
              "id": 22,
              "value": "academyLocationURL",
              "resultKey": "ACADEMY_LOCATION_URL",
              "displayCode": "",
              "displayOrder": 21
          },
          {
              "id": 23,
              "value": "academyLocationPhoneNo",
              "resultKey": "ACADEMY_LOCATION_PHONE_NO",
              "displayCode": "",
              "displayOrder": 22
          },
          {
              "id": 24,
              "value": "academyLocationId",
              "resultKey": "ACADEMY_LOCATION_ID",
              "displayCode": "",
              "displayOrder": 23
          },
          {
              "id": 25,
              "value": "academyId",
              "resultKey": "ACADEMY_ID",
              "displayCode": "",
              "displayOrder": 24
          },
          {
              "id": 26,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 25
          },
 	{
              "id": 27,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 26
          },
 	{
              "id": 28,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 27
          }
      ]
  }' where dataProviderId=@dataProviderId;

-- Send Offer Letter 

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_OFFER_LETTER_APPLICANT');

update sql_dtprovider
      set sqlQuery='SELECT T1.id AS USER_ID,T1.progBatchSeatConfigId as DLS_PROGRAM_BATCH_SEAT_CONFIG_ID
 FROM `application_program` T1
 INNER JOIN application T2 ON T1.applicationId = T2.id
 INNER JOIN `prog_batch_seat_config` T3 ON T3.id=T1.`progBatchSeatConfigId`
 WHERE T1.id IN (namedParams)
 <MSG@PROGRAM_CRITERIA> AND T1.programId IN (msg_scope_programIds)</MSG>
 <MSG@BATCH_CRITERIA> AND T3.programBatchId IN (msg_scope_batchIds)</MSG>' where dataProviderId=@dataProviderId;

-- Waiting Offer Letter

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='WAITING_FOR_OFFER_LETTER_RECIPIENT');

 update sql_dtprovider set sqlQuery="SELECT 
      T7.`id` AS ID,
      T4.`firstName` AS FIRST_NAME,
      T4.`middleName` AS MIDDLE_NAME,      
      T4.`lastName` AS LAST_NAME,    
      T4.`emailId` AS EMAIL_ID,
      T4.`mobileNumber` AS MOBILE_NO,
      T4.`mobileCountryCode` AS MOBILE_CODE,
      T3.`code` AS APPLICATION_CODE,
      T8.`displayName` AS ACADEMY_NAME_LOCATION,
      T8.`academyName` AS ACADEMY_NAME,
      T8.`locationName` AS LOCATION_NAME,
      T12.`programNameToBePrint` AS PROGRAM_NAME,
      T10.`printName` AS BATCH_PRINT_NAME,
      T18.`seatName` AS SEAT_TYPE,
      CONCAT(T23.phoneCountryCode,'-',T23.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
      T23.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
      T23.websiteURL AS ACADEMY_LOCATION_URL,
      (Case 
          when 
              T24.offerType = 'FIRM'
          then 
              'Firm'
  	when 
              T24.offerType = 'PROVISIONAL'
          then 
              'Provisional'
          else '' 
      end) as FIRM_OR_PROVISIONAL,
      (Case 
          when 
              T25.payerType = 'PERSON'
          then 
              (Case 
              when 
                  T25.firstName is not null
              then 
                  concat('and ',T25.firstName)
              else '' end)
          when 
              T25.payerType = 'CORPORATE'
          then
              (Case 
              when 
                  T25.contactPerson is not null
              then                 
  				concat('and ',T25.contactPerson)
              else '' end)
          else '' 
      end) as FEE_PAYER_FIRST_NAME,
      (Case 
          when 
              T25.payerType = 'PERSON'
          then 
              (Case 
              when 
                  T25.lastName is not null
              then 
                  T25.lastName
              else '' end)
          when 
              T25.payerType = 'CORPORATE'
          then
              ''
          else '' 
      end) as FEE_PAYER_LAST_NAME,
      (CASE
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'APPLIED'
          THEN
              'Applied'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'NOT_APPLIED'
          THEN
              'Not Applied'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'SOLD'
          THEN
              'Sold'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'SUBMITTED'
          THEN
              'Submitted'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'APPROVED'
          THEN
              'Approved'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'REJECTED'
          THEN
              'Rejected'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'WITHDRAWN'
          THEN
              'Withdrawn'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'CLOSED'
          THEN
              'Closed'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'DIRECT_ADMISSION'
          THEN
              'Direct Admission'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'MID_TERM_ADMISSION'
          THEN
              'Mid term admission'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
          THEN
              'Direct submission token generated'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
          THEN
              'Form sale token generated'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'NOT_SUBMITTED'
          THEN
              'Not Submitted'
          WHEN
              T3.currentStatus IS NOT NULL
                  AND T3.currentStatus = 'ADMISSION_GRANTED'
          THEN
              'Admission granted'
          ELSE ''
      END) AS APPLICATION_STATUS,
      (CASE
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'OFFER_LETTER_ACCEPTED'
          THEN
              'Offer letter accepted'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'OFFER_LETTER_ISSUED'
          THEN
              'Offer letter issued'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'OFFER_LETTER_REJECTED'
          THEN
              'Offer letter rejected'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'OFFER_LETTER_DUE'
          THEN
              'Offer letter due'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'ACTIVE'
          THEN
              'Active'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'APPROVED'
          THEN
              'Approved'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'ADMITTED'
          THEN
              'Admitted'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'ADMITTED_ON_TRIAL'
          THEN
              'Admitted on trial'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'ADMITTED_ON_PROVISIONAL'
          THEN
              'Admitted on provisional'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'REJECTED'
          THEN
              'Rejected'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'WITHDRAWN'
          THEN
              'Withdrawn'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
          THEN
              'Withdrawn after accepting offer letter'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'CLOSED'
          THEN
              'Closed'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
          THEN
              'Provisional offer issued'
              WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
          THEN
              'Provisional offer rejected'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'PROVISIONAL_OFFER_DUE'
          THEN
              'Provisional offer due'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'OFFER_EXPIRED'
          THEN
              'Offer Expired'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
          THEN
              'Provisional Offer Expired'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'ESCALATED'
          THEN
              'Escalated'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'ESCALATED_OFFER_REVIEWED'
          THEN
              'Escalated Offer Reviewed'
          WHEN
              T7.currentStatus IS NOT NULL
                  AND T7.currentStatus = 'WAITING_LIST'
          THEN
              'Waiting List'  
          ELSE ''
      END) AS OFFER_STATUS,
      DATE_FORMAT(T3.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
      (CASE
          WHEN
              T8.logoUrl IS NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl,
                      '/',
                      'emailer/images/logo_default_image.png')
          WHEN
              T8.logoUrl IS NULL
                  AND org.orgUrl IS NULL
          THEN
              'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
          ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
      END) AS LOGO_URL,
      (CASE
          WHEN
              T8.headerUrl IS NOT NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl, '/', T8.headerUrl)
          ELSE NULL
      END) AS HEADER_URL,
      (Case 
          when 
              T8.footerUrl is not null 
                  and org.orgUrl IS NOT NULL 
          then 
              CONCAT(org.orgUrl, '/', T8.footerUrl)
          else NULL 
      end) as FOOTER_URL,
      T8.id as ACADEMY_LOCATION_ID,
      T8.academyId as ACADEMY_ID,
       ml.itemValue as CORRESPONDENCE_LANGUAGE,
        T26.itemValue as CURRENT_ACTIVITY,
            T27.groupName AS PROGRAM_GROUP_NAME
  FROM
      application T3
          LEFT JOIN
      applicant_person T4 ON T4.id = T3.applicantPersonId
 		LEFT JOIN 
      `current_activity` T26 ON T26.id = T4.current_activity_id
          LEFT OUTER JOIN
      application_program T7 ON T7.applicationId = T3.id
          LEFT OUTER JOIN
      academy_location T8 ON T8.id = T7.academyLocationId        
          LEFT OUTER JOIN
      prog_batch_seat_config T9 on T9.id = T7.progBatchSeatConfigId
          LEFT OUTER JOIN
      batches T10 on T10.id = T9.programBatchId
          LEFT OUTER JOIN
      programs T12 ON T12.id = T7.programId 
          LEFT JOIN 
      `program_group` T27 ON T27.id = T12.programGroupId
          LEFT JOIN
      seat_types T18 on T18.id = T9.seatTypeId
          LEFT JOIN
      academy_location_addresses T22 ON T22.academyLocationId = T8.id
          LEFT JOIN
      address T23 ON T23.id = T22.addressId AND T23.addressTypeId = 10
          LEFT JOIN
      app_program_adm_details T24 on T24.applicationProgramId = T7.id and T24.isLatest = true
          LEFT JOIN
      fee_payer_detail T25 on T25.applicantPersonId = T4.id        
          LEFT OUTER JOIN    
      organizations org ON org.id = (SELECT 
              MAX(id)
          FROM
              organizations)
 	 LEFT JOIN
         multi_language ml on ml.id=T4.correspondence_language
  WHERE
      T7.id IN (namedParams) order by T25.id desc limit 1" ,
	jsonString='{
       "id": 1,
       "searchResultViewColumns": [
           {
               "id": 2,
               "value": "firstName",
               "resultKey": "FIRST_NAME",
               "displayCode": "",
               "displayOrder": 1
           },
           {
               "id": 3,
               "value": "middleName",
               "resultKey": "MIDDLE_NAME",
               "displayCode": "",
               "displayOrder": 2
           },
           {
               "id": 4,
               "value": "lastName",
               "resultKey": "LAST_NAME",
               "displayCode": "",
               "displayOrder": 3
           },
           {
               "id": 5,
               "value": "code",
               "resultKey": "APPLICATION_CODE",
               "displayCode": "",
               "displayOrder": 4
           },
           {
               "id": 6,
               "value": "displayName",
               "resultKey": "ACADEMY_NAME_LOCATION",
               "displayCode": "",
               "displayOrder": 5            
           },
           {
               "id": 7,
               "value": "academyName",
               "resultKey": "ACADEMY_NAME",
               "displayCode": "",
               "displayOrder": 6
           },
           {
               "id": 8,
               "value": "locationName",
               "resultKey": "LOCATION_NAME",
               "displayCode": "",
               "displayOrder": 7
           },
           {
               "id": 9,
               "value": "academyLocationEmailId",
               "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
               "displayCode": "",
               "displayOrder": 8
           },
           {
               "id": 10,
               "value": "academyLocationURL",
               "resultKey": "ACADEMY_LOCATION_URL",
               "displayCode": "",
               "displayOrder": 9
           },
           {
               "id": 11,
               "value": "academyLocationPhoneNo",
               "resultKey": "ACADEMY_LOCATION_PHONE_NO",
               "displayCode": "",
               "displayOrder": 10
           },
           {
               "id": 12,
               "value": "programName",
               "resultKey": "PROGRAM_NAME",
               "displayCode": "",
               "displayOrder": 11
           },
           {
               "id": 13,
               "value": "batchPrintName",
               "resultKey": "BATCH_PRINT_NAME",
               "displayCode": "",
               "displayOrder": 12
           },
           {
               "id": 14,
               "value": "seatType",
               "resultKey": "SEAT_TYPE",
               "displayCode": "",
               "displayOrder": 13            
           },
           {
               "id": 15,
               "value": "applicationStatus",
               "resultKey": "APPLICATION_STATUS",
               "displayCode": "",
               "displayOrder": 14
           },
           {
               "id": 16,
               "value": "offerStatus",
               "resultKey": "OFFER_STATUS",
               "displayCode": "",
               "displayOrder": 15
           },
           {
               "id": 17,
               "value": "firmOrProvisional",
               "resultKey": "FIRM_OR_PROVISIONAL",
               "displayCode": "",
               "displayOrder": 16
           },
           {
               "id": 18,
               "value": "applicationDate",
               "resultKey": "APPLICATION_DATE",
               "displayCode": "",
               "displayOrder": 17
           },
           {
               "id": 19,
               "value": "logoURL",
               "resultKey": "LOGO_URL",
               "displayCode": "",
               "displayOrder": 18
           },
           {
               "id": 20,
               "value": "headerUrl",
               "resultKey": "HEADER_URL",
               "displayCode": "",
               "displayOrder": 19
           },
           {
               "id": 21,
               "value": "footerUrl",
               "resultKey": "FOOTER_URL",
               "displayCode": "",
               "displayOrder": 20
           },
           {
               "id": 22,
               "value": "academyLocationId",
               "resultKey": "ACADEMY_LOCATION_ID",
               "displayCode": "",
               "displayOrder": 21
           },
           {
               "id": 23,
               "value": "academyId",
               "resultKey": "ACADEMY_ID",
               "displayCode": "",
               "displayOrder": 22            
           },
           {
               "id": 24,
               "value": "feePayerFirstName",
               "resultKey": "FEE_PAYER_FIRST_NAME",
               "displayCode": "",
               "displayOrder": 23            
           },
           {
               "id": 25,
               "value": "feePayerLastName",
               "resultKey": "FEE_PAYER_LAST_NAME",
               "displayCode": "",
               "displayOrder": 24            
           },
           {
              "id": 26,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 25
          },
 		{
              "id": 27,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 26
          },
 		{
              "id": 28,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 27
          }
       ]
   }' where dataProviderId=@dataProviderId;

-- Application REjection Post Assessment Velocity

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_REJECTION_POST_ASSESSMENT_VELOCITY_DL');

update sql_dtprovider set sqlQuery="SELECT T1.id AS USER_ID,T1.progBatchSeatConfigId as DLS_PROGRAM_BATCH_SEAT_CONFIG_ID
  FROM `application_program` T1
  INNER JOIN application T2 ON T1.applicationId = T2.id
  INNER JOIN `prog_batch_seat_config` T3 ON T3.id=T1.`progBatchSeatConfigId`
  WHERE T1.id IN (namedParams)
  <MSG@PROGRAM_CRITERIA> AND T1.programId IN (msg_scope_programIds)</MSG>
  <MSG@BATCH_CRITERIA> AND T3.programBatchId IN (msg_scope_batchIds)</MSG>" 
        where dataProviderId=@dataProviderId;

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_REJECTION_POST_ASSESSMENT_VELOCITY_RCPNT');

 update sql_dtprovider set sqlQuery="SELECT
     T6.id AS ID,
     T3.`salutationName` AS SALUTATION_NAME,
     T2.`firstName` AS FIRST_NAME,
     T2.`middleName` AS MIDDLE_NAME,
     T2.`lastName` AS LAST_NAME,
     T2.`emailId` AS EMAIL_ID,
     T2.`mobileNumber` AS MOBILE_NO,
     T2.`mobileCountryCode` AS MOBILE_CODE,
     T5.`loginId` AS LOGIN_ID,
     T17.`programNameToBePrint` AS program_Name,
     T16.`printName` AS batchName,
     T6.`rejection_remark` AS REJECTION_REMARK,
     CONVERT(FROM_BASE64(T5.passwordBase64) USING utf8) AS PASSWORD,
     CONCAT(T9.addressText,' ',T10.cityName,', ',T11.countryName,', ',T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
     DATE_FORMAT(T14.admissionOfferStartDate ,'%d-%m-%Y') as OFFER_LETTER_START_DATE,
     DATE_FORMAT(T14.admissionOfferEndDate ,'%d-%m-%Y') as OFFER_LETTER_END_DATE,
     'APPLICANT' AS USER_TYPE_KEY,
     ml.code as LANGUAGE_KEY,
  T3.`salutationNameInOtherLanguage` AS TITLE_IN_OTHER_LANGUAGE,
  T17.`programNameToBePrintLanguageOne` AS PROGRAM_PRINT_NAME_LANGUAGE,
  	ml.itemValue as CORRESPONDENCE_LANGUAGE,
 	T18.itemValue as CURRENT_ACTIVITY,
 	T19.groupName AS PROGRAM_GROUP_NAME
  FROM
     `application` T1 
  		INNER JOIN
  	`applicant_person` T2 ON T2.id = T1.applicantPersonId 
     	LEFT JOIN 
      `current_activity` T18 ON T18.id = T2.current_activity_id
  		LEFT JOIN
  	`salutations` T3 ON T3.`id` = T2.`salutationId`
  		LEFT JOIN
  	`external_user_association` T4 ON T4.`applicationId` = T1.`id`
  		LEFT JOIN
  	`external_users` T5 ON T5.`id` = T4.`externalUserId`
      LEFT JOIN
      application_program T6 ON T6.applicationId = T1.id
  		LEFT JOIN
      academy_location T7 ON T7.id = T6.academyLocationId
  		LEFT JOIN
      prog_batch_seat_config T15 on T15.id = T6.progBatchSeatConfigId
          LEFT JOIN
      batches T16 on T16.id = T15.programBatchId
          LEFT JOIN
      programs T17 ON T17.id = T6.programId    
          LEFT JOIN
      `program_group` T19 ON T19.id = T17.programGroupId 
          LEFT JOIN     
      academy_location_addresses T8 ON T8.academyLocationId = T7.id
  		LEFT OUTER JOIN
      address T9 ON T9.id = T8.addressId && T9.addressTypeId=10
  		LEFT OUTER JOIN
  	city T10 ON T10.id = T9.cityId
  		LEFT OUTER JOIN
  	country T11 ON T11.id = T10.countryId
  		LEFT OUTER JOIN
  	country_region T12 ON T12.id = T10.countryRegionId
  		LEFT JOIN
  	program_selection_process T13 on T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
  		LEFT JOIN
  	prog_slctn_process_admisn_conf T14 on T14.programSelectionProcessId = T13.id
                  LEFT JOIN
         multi_language ml on ml.id=T2.correspondence_language
  WHERE  T6.currentStatus='REJECTED' and
     T6.id IN 
     (
        namedParams
     )" ,
	jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "mobile Code",
              "resultKey": "MOBILE_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "Login Id",
              "resultKey": "LOGIN_ID",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "Password",
              "resultKey": "PASSWORD",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "Academy Location Address",
              "resultKey": "ACADEMY_LOCATION_ADDRESS",
              "displayCode": "",
              "displayOrder": 10
          },
          {
              "id": 12,
              "value": "Offer Letter Start Date",
              "resultKey": "OFFER_LETTER_START_DATE",
              "displayCode": "",
              "displayOrder": 11
          },
          {
              "id": 13,
              "value": "Offer Letter End Date",
              "resultKey": "OFFER_LETTER_END_DATE",
              "displayCode": "",
              "displayOrder": 12
          },
          {
              "id": 14,
              "value": "Program",
              "resultKey": "program_Name",
              "displayCode": "",
              "displayOrder": 13
          },
          {
              "id": 15,
              "value": "Batch",
              "resultKey": "batchName",
              "displayCode": "",
              "displayOrder": 14
          },
          {
              "id": 16,
              "value": "Remarks",
              "resultKey": "REJECTION_REMARK",
              "displayCode": "",
              "displayOrder": 15
          },
         {
              "id": 17,
              "value": "Salutation / Title in other Language",
              "resultKey": "TITLE_IN_OTHER_LANGUAGE",
              "displayCode": "",
              "displayOrder": 16
          },
         {
              "id": 18,
              "value": "Program Name in Other Language",
              "resultKey": "PROGRAM_PRINT_NAME_LANGUAGE",
              "displayCode": "",
              "displayOrder": 17
          },
          {
              "id": 19,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 18
          },
 		{
              "id": 20,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 19
          },
 		{
              "id": 21,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 20
          }
      ]
  }' where dataProviderId=@dataProviderId;

-- Approve Application

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_APPLICATION_DL');

update sql_dtprovider set sqlQuery="SELECT
 T1.id AS USER_ID
   FROM
      `application_program` T1 
      INNER JOIN
         `application` T2 
         ON T1.applicationId = T2.id 
   WHERE
      T1.id IN (namedParams)" 
        where dataProviderId=@dataProviderId;


SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_APPLICATION_RECIPIENTS');

update sql_dtprovider set 
sqlQuery= "select T4.id AS ID,
      T3.`salutationName` AS SALUTATION_NAME,
      T2.`firstName` AS FIRST_NAME,
      T2.`middleName` AS MIDDLE_NAME,
      T2.`lastName` AS LAST_NAME,
      T2.`emailId` AS EMAIL_ID,
      T2.`mobileNumber` AS MOBILE_NO,
      T1.`code` as APPLICATION_CODE,
  	ml.code as LANGUAGE_KEY,
      (CASE
          WHEN
              T5.headerUrl IS NOT NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl, '/', T5.headerUrl)
          ELSE NULL
      END) AS HEADER_URL,
      (Case 
          when 
              T5.footerUrl is not null 
                  and org.orgUrl IS NOT NULL 
          then 
              CONCAT(org.orgUrl, '/', T5.footerUrl)
          else NULL 
      end) as FOOTER_URL ,
      'APPLICANT' AS USER_TYPE_KEY,
 	  ml.itemValue as CORRESPONDENCE_LANGUAGE,
       T8.itemValue as CURRENT_ACTIVITY,
       T7.groupName AS PROGRAM_GROUP_NAME
      from application T1 
      left outer join 
      applicant_person T2 on T1.applicantPersonId=T2.id
      	LEFT JOIN 
      `current_activity` T8 ON T8.id = T2.current_activity_id
      left outer join 
      salutations T3 on T3.id = T2.salutationId
      LEFT OUTER JOIN
      application_program T4 ON T4.applicationId = T1.id
      LEFT JOIN 
      programs T6 ON T6.id = T4.programId 
       LEFT JOIN 
 	 program_group T7 ON T7.id = T6.programGroupId
          LEFT OUTER JOIN
      academy_location T5 ON T5.id = T4.academyLocationId
          LEFT OUTER JOIN
      organizations org ON org.id = (SELECT 
              MAX(id)
          FROM
              organizations)
  	left outer join multi_language ml on ml.id=T2.correspondence_language
      where T4.id in (namedParams) group by T4.id" ,
   jsonString=  '{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "code",
              "resultKey": "APPLICATION_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "headerUrl",
              "resultKey": "HEADER_URL",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "footerUrl",
              "resultKey": "FOOTER_URL",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 10
          },
 		{
              "id": 12,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 11
          },
 		{
              "id": 13,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 12
          }
      ]
  }' where dataProviderId=@dataProviderId;

-- Reject Application

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_APPLICATION_DL');

update sql_dtprovider set sqlQuery="SELECT T1.id AS USER_ID FROM `application_program` T1
  INNER JOIN application T2 ON T1.applicationId = T2.id
  WHERE T1.id IN (namedParams)" where dataProviderId=@dataProviderId;

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_APPLICATION_RECIPIENTS');

 update sql_dtprovider set sqlQuery="select T4.id AS ID,
  	T3.`salutationName` AS SALUTATION_NAME,
  	T2.`firstName` AS FIRST_NAME,
  	T2.`middleName` AS MIDDLE_NAME,
  	T2.`lastName` AS LAST_NAME,
  	T2.`emailId` AS EMAIL_ID,
  	T2.`mobileNumber` AS MOBILE_NO,
      T1.`code` as APPLICATION_CODE,
      T5.displayName AS ACADEMY_NAME_LOCATION,
      CONCAT(T7.addressText,' ',T8.cityName,', ',T9.countryName,', ',T10.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
      CONCAT(T7.phoneCountryCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
      T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
      T11.programName AS PROGRAM_NAME,
      T13.batchName AS BATCH_NAME,
      T14.printName AS APPLICATION_OWNER_NAME,
      T16.emailId AS OWNER_EMAIL_ID,
  	ml.`code` AS LANGUAGE_KEY,
      CONCAT(T16.mobileCountryCode,
              ' ',
              T16.mobileNumber) AS OWNER_MOBILE_NO,
      (CASE
          WHEN
              T5.logoUrl IS NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl,
                      '/',
                      'emailer/images/logo_default_image.png')
          WHEN
              T5.logoUrl IS NULL
                  AND org.orgUrl IS NULL
          THEN
              'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
          ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
      END) AS LOGO_URL,
  T3.`salutationNameInOtherLanguage` AS TITLE_IN_OTHER_LANGUAGE,T11.`programNameToBePrintLanguageOne` AS PROGRAM_PRINT_NAME_LANGUAGE,
       ml.itemValue as CORRESPONDENCE_LANGUAGE,
 	T19.itemValue as CURRENT_ACTIVITY,
 	T18.groupName AS PROGRAM_GROUP_NAME
 from application T1 
  		left outer join
      applicant_person T2 on T1.applicantPersonId=T2.id
 		LEFT JOIN 
      current_activity T19 ON T19.id = T2.current_activity_id
  		inner join
  	salutations T3 on T3.id = T2.salutationId
  		LEFT JOIN
      application_program T4 ON T4.applicationId = T1.id
  		LEFT OUTER JOIN
      academy_location T5 ON T5.id = T4.academyLocationId
          LEFT OUTER JOIN
      academy_location_addresses T6 ON T6.academyLocationId = T5.id
  		LEFT OUTER JOIN
      address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
  		LEFT OUTER JOIN
  	city T8 ON T8.id = T7.cityId
  		LEFT OUTER JOIN
  	country T9 ON T9.id = T8.countryId
  		LEFT OUTER JOIN
  	country_region T10 ON T10.id = T8.countryRegionId
  		LEFT OUTER JOIN
  	programs T11 ON T11.id = T4.programId
 		LEFT JOIN
 	program_group T18 ON T18.id = T11.programGroupId 
  		LEFT JOIN
      prog_batch_seat_config T22 ON T4.progBatchSeatConfigId=T22.id
  		LEFT JOIN
      batches T13 ON T13.id=T22.programBatchId
  		LEFT JOIN
  	users T14 ON T14.id=T1.applicationOwner
  		LEFT JOIN
      staffs T15 ON T15.userId = T14.id
          LEFT JOIN
      persons T16 ON T16.id = T15.personId
  		LEFT JOIN
      multi_language ml ON ml.id = T2.correspondence_language
  		LEFT OUTER JOIN
      organizations org ON org.id = (SELECT 
              MAX(id)
          FROM
              organizations)
      where T4.id in(namedParams) group by T4.id" ,
	jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "code",
              "resultKey": "APPLICATION_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "logoUrl",
              "resultKey": "LOGO_URL",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "displayName",
              "resultKey": "ACADEMY_NAME_LOCATION",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "Academy Location Address",
              "resultKey": "ACADEMY_LOCATION_ADDRESS",
              "displayCode": "",
              "displayOrder": 10
          },
          {
              "id": 12,
              "value": "Academy Location Phone No.",
              "resultKey": "ACADEMY_LOCATION_PHONE_NO",
              "displayCode": "",
              "displayOrder": 11
          },
          {
              "id": 13,
              "value": "Academy Location Email Id",
              "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 12
          },
          {
              "id": 14,
              "value": "Program Name",
              "resultKey": "PROGRAM_NAME",
              "displayCode": "",
              "displayOrder": 13
          },
          {
              "id": 15,
              "value": "Batch Name",
              "resultKey": "BATCH_NAME",
              "displayCode": "",
              "displayOrder": 14
          },
          {
              "id": 16,
              "value": "Application Owner Name",
              "resultKey": "APPLICATION_OWNER_NAME",
              "displayCode": "",
              "displayOrder": 15
          },
          {
              "id": 17,
              "value": "Owner EmailId",
              "resultKey": "OWNER_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 16
          },
          {
              "id": 18,
              "value": "Owner Mobile No",
              "resultKey": "OWNER_MOBILE_NO",
              "displayCode": "",
              "displayOrder": 17
          },
          {
              "id": 19,
              "value": "Reason for Rejection",
              "resultKey": "REASON_FOR_REJECTION",
              "displayCode": "",
              "displayOrder": 18
          },
          {
              "id": 20,
              "value": "Rejection Remarks",
              "resultKey": "REJECTION_REMARKS",
              "displayCode": "",
              "displayOrder": 19
          },{
              "id": 21,
              "value": "Salutation / Title in other Language",
              "resultKey": "TITLE_IN_OTHER_LANGUAGE",
              "displayCode": "",
              "displayOrder": 20
          },{
              "id": 22,
              "value": "Program Name in Other Language",
              "resultKey": "PROGRAM_PRINT_NAME_LANGUAGE",
              "displayCode": "",
              "displayOrder": 21
          },
 	{
              "id": 21,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 20
          },
 		{
              "id": 22,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 21
          },
 	{
              "id": 23,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 22
          }
      ]
  }' where dataProviderId=@dataProviderId;